/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.util.Enumeration;
import java.util.Hashtable;

public class PIHscLockPolicy {
    Hashtable mTaskPolicyHash = new Hashtable();
    private static Hashtable sLockPolicyHash = new Hashtable();
    private static final String GENERIC_POLICY = "Generic";
    public static final int LOCK_LEVEL_UNKNOWN = 0;
    public static final int LOCK_LEVEL_CEC = 1;
    public static final int LOCK_LEVEL_PARTITION = 2;
    public static final int LOCK_LEVEL_CEC_CMD = 3;
    public static final int LOCK_LEVEL_CEC_INST = 5;
    public static final int LOCK_LEVEL_PARTITION_INST = 6;
    public static final int LOCK_LEVEL_CEC_SAVE_AREA = 9;
    public static final int LOCK_LEVEL_CEC_MEM = 10;
    public static final int LOCK_LEVEL_CEC_CPU = 11;
    public static final int LOCK_LEVEL_CEC_IO = 12;
    public static final int LOCK_LEVEL_PARTITION_MEM = 13;
    public static final int LOCK_LEVEL_PARTITION_CPU = 14;
    public static final int LOCK_LEVEL_PARTITION_IO = 15;
    public static final int LOCK_LEVEL_NOT_DEFINED = 99;
    static String[][] sGenericTaskPolicy = new String[][]{{"createInstance", "W", "U"}, {"enumInstances", "R", "U"}, {"getInstance", "R", "U"}, {"setInstance", "W", "U"}, {"deleteInstance", "W", "U"}, {"execQuery", "R", "U"}};
    static String[][] sCecTaskPolicy = new String[][]{{"PowerOn", "R", "CI"}, {"PowerOnWithOptions", "N", "N"}, {"PowerOff", "W", "CI"}, {"ReIPL", "R", "CI"}, {"FastPowerOff", "W", "CI"}, {"ForcedReIPL", "R", "C"}, {"RebuildCec", "W", "C"}, {"RestoreNVRAM", "W", "C"}, {"PartitionDataRecover", "W", "C"}, {"CreateSystemProfile", "W", "C"}, {"ActivateSystemProfile", "N", "N"}, {"GetCurSPErrLogEntryID", "N", "C"}, {"GetListOfPlatformEventsLogEvents", "N", "N"}, {"GetSPErrorLog", "N", "N"}, {"GetSPErrorLogBCH", "N", "N"}, {"AcknowledgePlatformEventLogEntry", "N", "N"}, {"SetHscInfo", "W", "C"}, {"GetHscInfo", "N", "N"}, {"GetNumberOfHscInfoSlot", "R", "C"}, {"GetHostHscInfoSlotID", "R", "C"}, {"HandleEvent", "N", "N"}, {"IsLEDTypeSupported", "R", "C"}, {"GetLEDTypeList", "R", "C"}, {"SetLED", "N", "N"}, {"GetLEDState", "N", "N"}, {"GetCECTimeOfDay", "N", "N"}, {"SetCECTimeOfDay", "R", "C"}, {"GetLPARs", "R", "C"}, {"GetLPARProfiles", "R", "C"}, {"GetIODrawers", "R", "C"}, {"GetIOBuses", "R", "C"}, {"GetIOSlots", "R", "C"}, {"FSPFlash", "N", "N"}, {"AckFSPLogEntry", "R", "C"}, {"GetCurrentCECSrc", "R", "CI"}, {"GetPlatformSRCs", "R", "CI"}, {"ListOpenVirtualSerialConnection", "R", "C"}, {"InitializeDump", "N", "N"}, {"InitFireHoseDump", "N", "N"}, {"ReadDump", "R", "C"}, {"QueryDump", "R", "C"}, {"getDumpMasterHMC", "N", "N"}, {"setDumpMasterHMC", "N", "N"}, {"getCommandFailLog", "R", "C"}, {"GetProcPools", "R", "C"}, {"StartCodeUpdate", "R", "C"}, {"WriteLID", "R", "C"}, {"WriteLIDPartial", "R", "C"}, {"CodeUpdateComplete", "R", "C"}, {"CommitCodeUpdate", "R", "C"}, {"DeleteLID", "R", "C"}, {"SetCodeUpdateOwner", "R", "C"}, {"GetCodeUpdateStatus", "R", "C"}, {"ReadLID", "R", "C"}, {"ReadLIDPartial", "R", "C"}, {"ReadSpecialLID", "R", "C"}, {"OpenPhypFile", "R", "C"}, {"WritePhypFile", "R", "C"}, {"ClosePhypFile", "R", "C"}, {"GetFirmwareUpdateStatus", "R", "CI"}, {"StartFirmwareUpdate", "R", "C"}, {"RebootServiceProcessor", "R", "CI"}, {"BeginCodeUpdateProcess", "N", "N"}, {"EndCodeUpdateProcess", "N", "N"}, {"DumpLPARConfiguration", "R", "CC"}, {"ClearLPARConfiguration", "R", "C"}, {"StartConcMaintSession", "N", "C"}, {"GetPowerDomain", "R", "C"}, {"GetPowerDomainPowerState", "R", "C"}, {"SetServiceLock", "R", "C"}, {"ResetServiceLock", "R", "C"}, {"FruLevelActivate", "R", "C"}, {"FruLevelDeactivate", "R", "C"}, {"GetLocationCodeInfo", "R", "C"}, {"CanVaryOffPowerDomainPartition", "N", "C"}, {"CanVaryOffPowerDomainPlatform", "R", "C"}, {"VaryOffPowerDomainPartition", "N", "C"}, {"VaryOffPowerDomainPlatform", "R", "C"}, {"VaryOnPowerDomainPartition", "N", "C"}, {"VaryOnPowerDomainPlatform", "R", "C"}, {"QueryOptimalInteractivePerformanceRange", "N", "N"}, {"QueryRequiredMinMemoryForMax", "R", "CI"}, {"BroadcastMsgToAllOtherHMCs", "N", "N"}, {"BroadcastMessageToOneHMC", "N", "N"}, {"GetIOHubs", "R", "C"}, {"GetRioBuses", "R", "C"}, {"GetRioTopology", "R", "C"}, {"SetMultiHubMode", "R", "C"}, {"GetMultiHubMode", "R", "C"}, {"SetVirtualEthernetMACAddressPrefix", "W", "C"}, {"SetHmcConnectionStatus", "N", "N"}, {"platformPassword", "R", "C"}, {"setPassword", "R", "C"}, {"GetHmcInformation", "N", "N"}, {"GetHmcsWithLock", "N", "N"}, {"DisconnectHMC", "N", "N"}, {"GetPHYPHmcInfo", "N", "N"}, {"GetOnePHYPHmcInfo", "N", "N"}, {"GetSystemLocationCodeInfo", "N", "N"}, {"GetEnclosureList", "R", "C"}, {"GetEnclosureLocationCodeInfo", "R", "C"}, {"GetLocationCodeInfo", "R", "C"}, {"AbortLocationCodeCommand", "R", "C"}, {"GetLedLocCodeInfo", "N", "N"}, {"GetAllLocCodeInfo", "R", "C"}, {"GetIndentifyIndicatorStates", "N", "N"}, {"SetIdentifyIndicatorStates", "N", "N"}, {"GetLparSALeds", "N", "N"}, {"SetLparSALeds", "N", "N"}, {"GetPlatformSALed", "N", "N"}, {"SetPlatformSALed", "N", "N"}, {"LampTest", "N", "N"}, {"GetCodProcessorInfo", "R", "C"}, {"GetOnoffCodProcessorInfo", "R", "C"}, {"GetMeteredCodProcessorInfo", "R", "C"}, {"GetTrialCodProcessorInfo", "R", "C"}, {"ManageOnoffProcessors", "N", "N"}, {"ManageOnoffMemory", "N", "N"}, {"GetCodMemoryInfo", "R", "C"}, {"GetOnoffCodMemoryInfo", "R", "C"}, {"GetTrialCodMemoryInfo", "R", "C"}, {"ManageMeteredProcessors", "N", "N"}, {"DisableTrialResources", "N", "N"}, {"GetOnoffCodProcBillingInfo", "R", "C"}, {"GetOnoffCodMemBillingInfo", "R", "C"}, {"GetCodOrderInfo", "R", "C"}, {"SetCodCtaValue", "N", "N"}, {"SetCodRecoveryComplete", "N", "N"}, {"SetCodKey", "W", "C"}, {"GetCodHistoryLog", "R", "C"}, {"GetSharedProcessorPoolUtilization", "R", "C"}, {"GetPlatformIplParameters", "R", "C"}, {"SetPlatformIplParameters", "W", "C"}, {"ProfileDataOps", "W", "C"}, {"SaveSystemCredential", "W", "CS"}, {"GetSystemCredential", "W", "CS"}, {"GetCecConfigId", "R", "C"}, {"SetCecConfigId", "R", "C"}, {"GetIoDrawerConfigIdAndMtms", "R", "C"}, {"SetIoDrawerMtms", "R", "C"}, {"SetIoDrawerConfigId", "R", "C"}, {"memRecovery", "W", "C"}, {"cpuRecovery", "W", "C"}, {"ioRecovery", "W", "C"}, {"GetProcessorFeatureCode", "N", "N"}, {"SetFoDKey", "W", "C"}, {"GetFoDOrderInfo", "N", "N"}, {"fspSupplementLock", "R", "C"}, {"removePlanar", "N", "N"}};
    static String[][] sPartitionTaskPolicy = new String[][]{{"ActivateLparProfile", "W", "C"}, {"removeMem", "W", "PM"}, {"addMem", "W", "CM"}, {"moveMem", "W", "CM"}, {"varyOnMemory", "W", "C"}, {"varyOffMemory", "W", "P"}, {"OS400RPACheck", "N", "N"}, {"startLparBatchMode", "N", "N"}, {"commitLparBatch", "N", "N"}, {"setDlparCapability", "N", "N"}, {"getMemInfo", "R", "P"}, {"CPULPARTask", "W", "CC"}, {"varyOnOffProcessing", "W", "P"}, {"getProcessorData", "N", "N"}, {"addIo", "W", "CO"}, {"removeIo", "W", "PO"}, {"moveIo", "W", "CO"}, {"varyOnOffPHB", "R", "C"}, {"varyOnIo", "W", "P"}, {"varyOffIo", "R", "P"}, {"addVirtualEthernet", "W", "P"}, {"addVirtualSerialSCSI", "W", "P"}, {"removeVirtualSlots", "W", "P"}, {"getIoSlotInfo", "N", "N"}, {"ActivatePartition", "W", "C"}, {"ActivatePartitionWithBootMode", "W", "C"}, {"ActivateLparProfileWithOptions", "W", "C"}, {"ActivateAndPowerOn", "W", "C"}, {"VirtualTTYRequest", "N", "N"}, {"PowerOff", "R", "P"}, {"PowerOn", "R", "P"}, {"EmergencyPowerOff", "R", "P"}, {"ImmediateReIPL", "R", "P"}, {"DumpToLoadSrc", "R", "P"}, {"MSDIPL", "R", "P"}, {"ForceDSTOnConsole", "R", "C"}, {"RemoteDSTEnablement", "R", "C"}, {"DiskUnitIOPOp", "R", "C"}, {"MemLPARTask", "W", "C"}, {"IOLPARTask", "W", "C"}, {"ListHostingPartitions", "R", "P"}, {"SetHostingPartitionIDs", "W", "P"}, {"SetClusterGroupID", "W", "C"}, {"ChangeDefaultProfile", "W", "P"}, {"GetTaggedIO", "R", "P"}, {"SetTaggedIO", "W", "P"}, {"GetIOPoolConfig", "N", "N"}, {"SetIOPoolConfig", "N", "N"}, {"GetSupportedVirtualPanelFunct", "R", "C"}, {"PushVirtualPanelFunct", "R", "C"}, {"getCurrentSRC", "R", "CI"}, {"getSrcFromSeqNum", "R", "CI"}, {"QueryRequiredMinMemoryForMax", "R", "CI"}, {"GetServerAdapter", "R", "P"}, {"GetClientAdapter", "R", "C"}, {"OSShutdown", "R", "PI"}, {"SetLparIoPool", "N", "N"}, {"SendIOServerCMD", "R", "PI"}};
    static String[][] sSysProfTaskPolicy = new String[][]{{"ValidateSysProfile", "R", "C"}, {"UpdateSystemProfile", "W", "C"}};
    String mClassName;
    String[][] mTaskPolicy;

    private PIHscLockPolicy(String string) {
        this.mClassName = string;
        if (string.equalsIgnoreCase("IBMHSC_ComputerSystem")) {
            this.mTaskPolicy = sCecTaskPolicy;
        } else if (string.equalsIgnoreCase("IBMHSC_Partition")) {
            this.mTaskPolicy = sPartitionTaskPolicy;
        } else if (string.equalsIgnoreCase("IBMHSC_SystemProfile")) {
            this.mTaskPolicy = sSysProfTaskPolicy;
        } else {
            this.mTaskPolicy = sGenericTaskPolicy;
            this.mClassName = GENERIC_POLICY;
        }
        for (int i = 0; i < this.mTaskPolicy.length; ++i) {
            this.mTaskPolicyHash.put(this.mTaskPolicy[i][0].toLowerCase(), new Integer(i));
        }
    }

    public static PIHscLockPolicy getPIHscLockPolicy() {
        String string = GENERIC_POLICY;
        PIHscLockPolicy pIHscLockPolicy = (PIHscLockPolicy)sLockPolicyHash.get(string);
        if (pIHscLockPolicy == null) {
            pIHscLockPolicy = new PIHscLockPolicy(string);
            sLockPolicyHash.put(string, pIHscLockPolicy);
        }
        return pIHscLockPolicy;
    }

    public static PIHscLockPolicy getPIHscLockPolicy(String string) {
        PIHscLockPolicy pIHscLockPolicy;
        if (!(string.equalsIgnoreCase("IBMHSC_ComputerSystem") || string.equalsIgnoreCase("IBMHSC_Partition") || string.equalsIgnoreCase("IBMHSC_SystemProfile"))) {
            string = GENERIC_POLICY;
        }
        if ((pIHscLockPolicy = (PIHscLockPolicy)sLockPolicyHash.get(string)) == null) {
            pIHscLockPolicy = new PIHscLockPolicy(string);
            sLockPolicyHash.put(string, pIHscLockPolicy);
            System.out.println(string + " PIHscLockPolicy found");
        }
        return pIHscLockPolicy;
    }

    public String getNameSpace() {
        return "root/ibmhscS1_0";
    }

    private boolean isGenericPolicy() {
        return this.mClassName.equalsIgnoreCase(GENERIC_POLICY);
    }

    public int getLockType(String string) {
        int n = 1;
        Integer n2 = (Integer)this.mTaskPolicyHash.get(string.toLowerCase());
        if (n2 == null) {
            if (!this.isGenericPolicy()) {
                PIHscLockPolicy pIHscLockPolicy = PIHscLockPolicy.getPIHscLockPolicy();
                return pIHscLockPolicy.getLockType(string);
            }
            System.out.println("getLockType: Task name " + string + " not found. WRITE lock is used.");
            return n;
        }
        int n3 = n2;
        String string2 = this.mTaskPolicy[n3][1];
        System.out.println("Task name " + string + " found in Lock Policy " + this.mClassName);
        if (string2 == null) {
            System.out.println("Wrong lock type for " + string + ". WRITE lock is used.");
            return n;
        }
        if (string2.equalsIgnoreCase("R")) {
            n = 0;
        } else if (string2.equalsIgnoreCase("W")) {
            n = 1;
        } else if (string2.equalsIgnoreCase("GR")) {
            n = 2;
        } else if (string2.equalsIgnoreCase("GW")) {
            n = 3;
        } else if (string2.equalsIgnoreCase("N")) {
            n = -1;
        } else {
            System.out.println("Wrong lock type for " + string + ". WRITE lock is used.");
        }
        return n;
    }

    public int getLockLevel(String string) {
        int n = 0;
        Integer n2 = (Integer)this.mTaskPolicyHash.get(string.toLowerCase());
        if (n2 == null) {
            System.out.println("getLockLevel: Task name " + string + " not found in Lock Policy " + this.mClassName);
            if (!this.isGenericPolicy()) {
                PIHscLockPolicy pIHscLockPolicy = PIHscLockPolicy.getPIHscLockPolicy();
                System.out.println("getLockLevel: use generic policy.");
                return pIHscLockPolicy.getLockLevel(string);
            }
            System.out.println("getLockLevel: Task name " + string + " not found.");
            return n;
        }
        int n3 = n2;
        String string2 = this.mTaskPolicy[n3][2];
        System.out.println("getLockLevel: Task name " + string + " found in Lock Policy " + this.mClassName);
        System.out.println("getLockLevel: lock level = " + string2);
        if (string2 == null) {
            System.out.println("getLockLevel: Unknown lock level for " + string);
            return 0;
        }
        if (string2.equalsIgnoreCase("U")) {
            n = 0;
        } else if (string2.equalsIgnoreCase("N")) {
            n = 99;
        } else if (string2.equalsIgnoreCase("C")) {
            n = 1;
        } else if (string2.equalsIgnoreCase("P")) {
            n = 2;
        } else if (string2.equalsIgnoreCase("CC")) {
            n = 3;
        } else if (string2.equalsIgnoreCase("CI")) {
            n = 5;
        } else if (string2.equalsIgnoreCase("PI")) {
            n = 6;
        } else if (string2.equalsIgnoreCase("CS")) {
            n = 9;
        } else if (string2.equalsIgnoreCase("CM")) {
            n = 10;
        } else if (string2.equalsIgnoreCase("CC")) {
            n = 11;
        } else if (string2.equalsIgnoreCase("CO")) {
            n = 12;
        } else if (string2.equalsIgnoreCase("PM")) {
            n = 13;
        } else if (string2.equalsIgnoreCase("PC")) {
            n = 14;
        } else if (string2.equalsIgnoreCase("PO")) {
            n = 15;
        } else {
            System.out.println("getLockLevel: Unknown lock level for " + string);
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mTaskPolicy.length; ++i) {
            stringBuffer.append(this.mTaskPolicy[i][0]);
            stringBuffer.append(", ");
            stringBuffer.append(this.mTaskPolicy[i][1]);
            stringBuffer.append(", ");
            stringBuffer.append(this.mTaskPolicy[i][2]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Enumeration enumeration = sLockPolicyHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PIHscLockPolicy pIHscLockPolicy = (PIHscLockPolicy)sLockPolicyHash.get(string);
            System.out.println("====Tasks of " + string);
            System.out.println(pIHscLockPolicy);
        }
    }
}

